<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class VerifyWorkflow
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, Closure $next, ...$steps)
    {
        foreach ($steps as $step) {
            if (!session()->has($step)) {
                return redirect()->route('home');
            }
        }
        
        return $next($request);
    }
}
